<?php
date_default_timezone_set("Asia/Tehran");

function multiple_threads_request($nodes)
{

    $mh = curl_multi_init();

    $curl_array = array();

    foreach ($nodes as $i => $url) {

        $curl_array[$i] = curl_init($url);

        curl_setopt($curl_array[$i], CURLOPT_RETURNTRANSFER, true);
        curl_setopt($mh, CURLOPT_TIMEOUT, 30); // تنظیم تایم اوت
        curl_setopt($mh, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($mh, CURLOPT_SSL_VERIFYPEER, false); // غیرفعال کردن SSL (در صورت نیاز)


        curl_multi_add_handle($mh, $curl_array[$i]);

    }

    $running = NULL;

    do {

        usleep(10000);

        curl_multi_exec($mh, $running);

    } while ($running > 0);


    $res = array();

    foreach ($nodes as $i => $url) {

        $res[$i] = curl_multi_getcontent($curl_array[$i]);

    }


    foreach ($nodes as $i => $url) {

        curl_multi_remove_handle($mh, $curl_array[$i]);

    }

    curl_multi_close($mh);

    return $res;

}

function curl($url){
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL=>$url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    return $response;
}

function isJson($string)
{
    json_decode($string);
    return json_last_error() === JSON_ERROR_NONE;
}

function getMarketDepth($market, $limit = 5, $interval = "0")
{
    $url = 'https://api.coinex.com/v2/spot/depth';
    $query = http_build_query([
        'market' => $market,
        'limit' => $limit,
        'interval' => $interval
    ]);
    $finalUrl = $url . '?' . $query;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $finalUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    $responseData = json_decode($response, true);
    return $responseData['data'];
}



//=============================== curl live
function createCurl()
{
    global $ch;
    if ($ch) {
        return; // Reuse existing handle
    }
    $ch = curl_init();

    // General cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Connection: keep-alive',
        'Accept-Encoding: gzip, deflate'
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Total timeout
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2); // Connection timeout
    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_2_0); // Use HTTP/2
    curl_setopt($ch, CURLOPT_ENCODING, ''); // Enable compression
}

function sendCurl($url, $method = 'GET', $data = null, $timeoutms = null)
{
    global $ch;
    if (!$ch) {
        createCurl();
    }

    curl_setopt($ch, CURLOPT_URL, $url);

    if (strtoupper($method) === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
    } else {
        curl_setopt($ch, CURLOPT_POST, false);
        if ($data) {
            $urlWithParams = $url . '?' . http_build_query($data);
            curl_setopt($ch, CURLOPT_URL, $urlWithParams);
        }
    }

    if ($timeoutms) {
        curl_setopt($ch, CURLOPT_TIMEOUT_MS, $timeoutms);
    }

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        closeCurl(); // Reset the handle on error
        return "cURL Error: $error";
    }

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($httpCode >= 400) {
        closeCurl(); // Reset the handle on error
        return "HTTP Error: $httpCode";
    }

    return $response;
}

function closeCurl()
{
    global $ch;
    if ($ch) {
        curl_close($ch);
        $ch = null;
    }
}